/* $Id: direct.c,v 1.8 1998/07/20 23:37:03 ericb Exp $ */
/* Copyright (C) 1997 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Keith Bayern */

#include <stdio.h>
#include <string.h>
#include <visa.h>




#define       HPE1432_DEVICE_TYPE_REG         2
#define       HPE1432_ID_REG                  0

#define RAM_A24_LOC 0x100
#define TEST_WORD 0x36ae


static char *errtostring(ViStatus err)
{
static char errstr[100];

	sprintf(errstr,"%lx, ",(long)err);

	switch((long)err) {
	case VI_ERROR_SYSTEM_ERROR       :
	    strcat(errstr,"VI_ERROR_SYSTEM_ERROR");
	    break;

	case VI_ERROR_INV_OBJECT         :
	    strcat(errstr,"VI_ERROR_INV_OBJECT");
	    break;

	case VI_ERROR_INV_EXPR           :
	    strcat(errstr,"VI_ERROR_INV_EXPR");
	    break;

	case VI_ERROR_RSRC_NFOUND        :
	    strcat(errstr,"VI_ERROR_RSRC_NFOUND");
	    break;

	case VI_ERROR_INV_RSRC_NAME      :
	    strcat(errstr,"VI_ERROR_INV_RSRC_NAME");
	    break;

	case VI_ERROR_INV_ACC_MODE       :
	    strcat(errstr,"VI_ERROR_INV_ACC_MODE");
	    break;

	case VI_ERROR_TMO                :
	    strcat(errstr,"VI_ERROR_TMO");
	    break;

	case VI_ERROR_CLOSING_FAILED     :
	    strcat(errstr,"VI_ERROR_CLOSING_FAILED");
	    break;

	case VI_ERROR_NSUP_ATTR          :
	    strcat(errstr,"VI_ERROR_NSUP_ATTR");
	    break;

	case VI_ERROR_NSUP_ATTR_STATE    :
	    strcat(errstr,"VI_ERROR_NSUP_ATTR_STATE");
	    break;

	case VI_ERROR_ATTR_READONLY      :
	    strcat(errstr,"VI_ERROR_ATTR_READONLY");
	    break;

	case VI_ERROR_INV_EVENT          :
	    strcat(errstr,"VI_ERROR_INV_EVENT");
	    break;

	case VI_ERROR_INV_MECH           :
	    strcat(errstr,"VI_ERROR_INV_MECH");
	    break;

	case VI_ERROR_HNDLR_NINSTALLED   :
	    strcat(errstr,"VI_ERROR_HNDLR_NINSTALLED");
	    break;

	case VI_ERROR_INV_HNDLR_REF      :
	    strcat(errstr,"VI_ERROR_INV_HNDLR_REF");
	    break;

	case VI_ERROR_INV_CONTEXT        :
	    strcat(errstr,"VI_ERROR_INV_CONTEXT");
	    break;

	case VI_ERROR_RAW_WR_PROT_VIOL   :
	    strcat(errstr,"VI_ERROR_RAW_WR_PROT_VIOL");
	    break;

	case VI_ERROR_RAW_RD_PROT_VIOL   :
	    strcat(errstr,"VI_ERROR_RAW_RD_PROT_VIOL");
	    break;

	case VI_ERROR_OUTP_PROT_VIOL     :
	    strcat(errstr,"VI_ERROR_OUTP_PROT_VIOL");
	    break;

	case VI_ERROR_INP_PROT_VIOL      :
	    strcat(errstr,"VI_ERROR_INP_PROT_VIOL");
	    break;

	case VI_ERROR_BERR               :
	    strcat(errstr,"VI_ERROR_BERR");
	    break;

	case VI_ERROR_INV_SETUP          :
	    strcat(errstr,"VI_ERROR_INV_SETUP");
	    break;

	case VI_ERROR_ALLOC              :
	    strcat(errstr,"VI_ERROR_ALLOC");
	    break;

	case VI_ERROR_INV_MASK           :
	    strcat(errstr,"VI_ERROR_INV_MASK");
	    break;

	case VI_ERROR_IO                 :
	    strcat(errstr,"VI_ERROR_IO");
	    break;

	case VI_ERROR_INV_FMT            :
	    strcat(errstr,"VI_ERROR_INV_FMT");
	    break;

	case VI_ERROR_NSUP_FMT           :
	    strcat(errstr,"VI_ERROR_NSUP_FMT");
	    break;

	case VI_ERROR_LINE_IN_USE        :
	    strcat(errstr,"VI_ERROR_LINE_IN_USE");
	    break;

	case VI_ERROR_SRQ_NOCCURRED      :
	    strcat(errstr,"VI_ERROR_SRQ_NOCCURRED");
	    break;

	case VI_ERROR_INV_SPACE          :
	    strcat(errstr,"VI_ERROR_INV_SPACE");
	    break;

	case VI_ERROR_INV_OFFSET         :
	    strcat(errstr,"VI_ERROR_INV_OFFSET");
	    break;

	case VI_ERROR_NSUP_OFFSET        :
	    strcat(errstr,"VI_ERROR_NSUP_OFFSET");
	    break;

	case VI_ERROR_WINDOW_NMAPPED     :
	    strcat(errstr,"VI_ERROR_WINDOW_NMAPPED");
	    break;

	case VI_ERROR_NLISTENERS         :
	    strcat(errstr,"VI_ERROR_NLISTENERS");
	    break;

	case VI_ERROR_NCIC               :
	    strcat(errstr,"VI_ERROR_NCIC");
	    break;

	case VI_ERROR_NSUP_OPER          :
	    strcat(errstr,"VI_ERROR_NSUP_OPER");
	    break;

	case VI_ERROR_NSUP_WIDTH         :
	    strcat(errstr,"VI_ERROR_NSUP_WIDTH");
	    break;

	case VI_ERROR_INV_PROT           :
	    strcat(errstr,"VI_ERROR_INV_PROT");
	    break;

	case VI_ERROR_INV_SIZE           :
	    strcat(errstr,"VI_ERROR_INV_SIZE");
	    break;

	case VI_ERROR_WINDOW_MAPPED      :
	    strcat(errstr,"VI_ERROR_WINDOW_MAPPED");
	    break;

	case VI_ERROR_NIMPL_OPER         :
	    strcat(errstr,"VI_ERROR_NIMPL_OPER");
	    break;

	default:
	    strcat(errstr,"not listed, check manual");
	    break;
	}
	return errstr;
}

void print_usage()
{
	    printf("Usage: direct [resource [ LA ] ]\n");
	    printf("Example: direct GPIB-VXI0 9\n");
	    printf("Defaults: direct VXI0 8\n");
	    return;
}



void main(int argc, char *argv[])
{
ViStatus	vierr;
ViSession	vi;
ViSession	drm;
ViUInt16        idreg;
ViUInt16        dtype;
ViUInt16        idregA24;
ViUInt16        dtypeA24;
ViChar 		openstr[100];

    if(argc>1)
    {
	if(!strcmp(argv[1],"-u") || !strcmp(argv[1],"-U") )
	{
	    print_usage();
	    return;
	}
    }


    /* get logical address */
    if(argc==1)
    {
        sprintf(openstr,"VXI0::%s::INSTR","8");
    }
    else if(argc==2)
    {
        sprintf(openstr,"%s::8::INSTR",argv[1]);
    }
    else if(argc==3)
    {
        sprintf(openstr,"%s::%s::INSTR",argv[1],argv[2]);
    }
    else
    {
	print_usage();
	return;
    }


    vierr=viOpenDefaultRM(&drm);
    if(vierr!=VI_SUCCESS)
    { 
	char *es;
	es=errtostring(vierr);\
	printf("viOpenDefaultRM failed and returned %ld, %s\n",vierr,es);
	printf("Exiting\n");
	return;
    }

    printf("defaultRM = %p\n",drm);

    printf("calling viOpen with %s\n",openstr);


    vierr=viOpen(drm,openstr,0,0,&vi);
    if(vierr!=VI_SUCCESS)
    { 
	char *es;
	es=errtostring(vierr);\
	printf("viOpen failed and returned %ld, %s\n",vierr,es);
	printf("Exiting\n");
	return;
    }
    printf("session = %p\n",vi);


    vierr=viIn16(vi,VI_A16_SPACE,HPE1432_ID_REG,&idreg);
    if(vierr!=VI_SUCCESS)
    {
	char *es;
	es=errtostring(vierr);\
	printf("viIn16 (A16) for ID reg failed and returned %ld, %s\n",vierr,es);
	printf("Exiting\n");
	return;
    }

printf("A16 read of E1432_ID_REG = %p\n",idreg);
    
    vierr=viIn16(vi,VI_A16_SPACE,HPE1432_DEVICE_TYPE_REG,&dtype);
    if(vierr!=VI_SUCCESS)
    {
	char *es;
	es=errtostring(vierr);\
	printf("viIn16 (A16) for device type reg failed and returned %ld, %s\n",vierr,es);
	printf("Exiting\n");
	return;
    }
    
printf("A16 read of E1432_DEVICE_TYPE_REG = %p\n",dtype);

#define SEMA_MODEL_CODE         (0x0200)
#define DTYP_MODEL_CODE_MASK    (0x0FF8)
#define SUBC_MFR_ID_MASK        (0x0FFF)
#define SUBC_MFR_HP             (0x0FFF)

    if(   ((idreg&SUBC_MFR_ID_MASK)==SUBC_MFR_HP)
	&&((dtype&DTYP_MODEL_CODE_MASK)==SEMA_MODEL_CODE))
	{
	    printf("It is an E1432 series\n");
	}
	else
	{
	    printf("It is NOT an E1432 series\n");
	}

    /* test A24 space */

    vierr=viIn16(vi,VI_A24_SPACE,HPE1432_ID_REG,&idregA24);
    if(vierr!=VI_SUCCESS)
    {
	char *es;
	es=errtostring(vierr);\
	printf("viIn16 (A24) for ID reg failed and returned %ld, %s\n",vierr,es);
	printf("Exiting\n");
	return;
    }

printf("A24 read of E1432_ID_REG = %p\n",idregA24);

    if(idregA24!=idreg)
    {
	printf("A24 read of E1432_ID_REG did not match A16 read\n");
	printf("Exiting\n");
	return;
    }
    
    vierr=viIn16(vi,VI_A24_SPACE,HPE1432_DEVICE_TYPE_REG,&dtypeA24);
    if(vierr!=VI_SUCCESS)
    {
	char *es;
	es=errtostring(vierr);\
	printf("viIn16 (A24) for device type reg failed and returned %ld, %s\n",vierr,es);
	printf("Exiting\n");
	return;
    }
    
printf("A24 read of E1432_DEVICE_TYPE_REG = %p\n",dtypeA24);

    if(dtype!=dtypeA24)
    {
	printf("A24 read of HPE1432_DEVICE_TYPE_REG did not match A16 read\n");
	printf("Exiting\n");
	return;
    }
    

    /* write test of A24 */

#if 0

    vierr=viOut16(vi,VI_A24_SPACE,RAM_A24_LOC,TEST_WORD);
    if(vierr!=VI_SUCCESS)
    {
	char *es;
	es=errtostring(vierr);\
	printf("viOut16 (A24) at %p failed and returned %ld, %s\n",
		     RAM_A24_LOC,vierr,es);
	printf("Exiting\n");
	return;
    }


    vierr=viIn16(vi,VI_A24_SPACE,RAM_A24_LOC,&dtype);
    if(vierr!=VI_SUCCESS)
    {
	char *es;
	es=errtostring(vierr);\
	printf("viIn16 (A24) at %p failed and returned %ld, %s\n",
		     RAM_A24_LOC,vierr,es);
	printf("Exiting\n");
	return;
    }


    if(dtype!=TEST_WORD)
    {
	printf("wrote %p to %p, read back %p\n",TEST_WORD,RAM_A24_LOC,dtype);
	return;
    }
    printf("Write - read test of A24 passed\n");
    


#endif

    printf("\n      ALL TESTS PASS\n\n");

    viClose(vi);

}
